/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.GrammarEditorShell;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import net.nooj4nlp.controller.GrammarEditorShell.GrammarEditorShellController;
import net.nooj4nlp.engine.Graph;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.gui.shells.GrammarEditorShell;
import org.apache.commons.lang3.SystemUtils;

public class JPGraphMouseListener
implements MouseListener {
    private GrammarEditorShell editor;
    private GrammarEditorShellController controller;

    public JPGraphMouseListener(GrammarEditorShell shell) {
        this.editor = shell;
        this.controller = this.editor.getController();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.controller.getMouseN();
            int mouseN = this.controller.mouseN;
            if (mouseN == -1) {
                if (e.isControlDown() || e.isAltDown()) {
                    int rx = (int)((float)this.controller.mouseOX / this.controller.grf.scale) - this.controller.grf.epsilonWid / 2;
                    int ry = (int)((float)this.controller.mouseOY / this.controller.grf.scale);
                    int snode = this.controller.grf.addNode("<E>", rx, ry);
                    this.controller.grf.hei.set(snode, this.controller.grf.epsilonHei);
                    this.controller.grf.wid.set(snode, this.controller.grf.epsilonWid);
                    this.controller.grf.widB.set(snode, this.controller.grf.epsilonwidB);
                    this.controller.modify("create node #" + snode, false, false);
                    this.controller.grf.inodeconnected = -1;
                    this.controller.grf.nbofnodesconnected = 0;
                    for (int inode = 0; inode < this.controller.grf.label.size(); ++inode) {
                        boolean sel = this.controller.grf.selected.get(inode);
                        if (!sel || inode == 1) continue;
                        this.controller.grf.inodeconnected = inode;
                        ++this.controller.grf.nbofnodesconnected;
                        ArrayList<Integer> children = this.controller.grf.child.get(inode);
                        children.add(snode);
                        this.controller.grf.selected.set(inode, false);
                    }
                    if (this.controller.grf.nbofnodesconnected == 1) {
                        this.controller.modify("connect node #" + this.controller.grf.inodeconnected + " to node #" + snode, false, true);
                    }
                    if (this.controller.grf.nbofnodesconnected > 1) {
                        this.controller.modify("connect " + this.controller.grf.nbofnodesconnected + " nodes to node #" + snode, false, true);
                    }
                    this.controller.grf.selected.set(snode, true);
                    this.controller.displayRtbox(snode);
                } else {
                    if (this.controller.mouseEdited != -1) {
                        this.controller.grf.label.set(this.controller.mouseEdited, this.controller.originallabel);
                        this.controller.hideRtbox();
                    }
                    for (int inode = 0; inode < this.controller.grf.label.size(); ++inode) {
                        this.controller.grf.selected.set(inode, false);
                    }
                }
            } else {
                if (mouseN != this.controller.lasteditednode) {
                    this.controller.lasteditednode = mouseN;
                    this.controller.nbofcreatednodes = 1;
                }
                if (this.controller.mouseEdited != -1) {
                    this.controller.grf.label.set(this.controller.mouseEdited, this.controller.originallabel);
                    this.controller.hideRtbox();
                    return;
                }
                if (e.isShiftDown()) {
                    boolean sel = this.controller.grf.selected.get(mouseN);
                    this.controller.grf.selected.set(mouseN, !sel);
                } else if (e.isControlDown()) {
                    this.controller.grf.selected.set(mouseN, false);
                    this.controller.displayRtbox(mouseN);
                } else if (e.isAltDown() && this.controller.grf.interline != 0) {
                    int y0 = (int)((float)this.controller.grf.posY.get(mouseN).intValue() * this.controller.grf.scale) - this.controller.grf.hei.get(mouseN);
                    int line = (this.controller.mouseOY - y0) / this.controller.grf.interline;
                    String label = this.controller.grf.label.get(mouseN);
                    String output = null;
                    RefObject<Object> outputRef = new RefObject<Object>(output);
                    String[] terms = Graph.inLineLabel(label, outputRef);
                    output = (String)outputRef.argvalue;
                    if (line < terms.length && terms[line].length() > 0 && terms[line].charAt(0) == ':') {
                        this.controller.findAndLoadGraph(terms[line].substring(1));
                    } else {
                        this.controller.grf.selected.set(mouseN, false);
                        this.controller.displayRtbox(mouseN);
                    }
                } else {
                    boolean connection = false;
                    this.controller.grf.nbofnodesconnected = 0;
                    this.controller.grf.inodeconnected = -1;
                    this.controller.grf.onedisconnectionatleast = false;
                    this.controller.grf.oneconnectionatleast = false;
                    for (int inode = 0; inode < this.controller.grf.label.size(); ++inode) {
                        int ichild;
                        boolean sel = this.controller.grf.selected.get(inode);
                        if (!sel || inode == 1) continue;
                        connection = true;
                        ArrayList<Integer> children = this.controller.grf.child.get(inode);
                        for (ichild = 0; ichild < children.size() && children.get(ichild) != mouseN; ++ichild) {
                        }
                        this.controller.grf.inodeconnected = inode;
                        ++this.controller.grf.nbofnodesconnected;
                        if (ichild < children.size()) {
                            children.remove(ichild);
                            this.controller.grf.onedisconnectionatleast = true;
                        } else {
                            this.controller.grf.oneconnectionatleast = true;
                            children.add(mouseN);
                        }
                        if (e.isAltDown() || e.isControlDown() || e.isShiftDown()) continue;
                        this.controller.grf.selected.set(inode, false);
                    }
                    if (!connection) {
                        this.controller.grf.selected.set(mouseN, true);
                    } else if (this.controller.grf.nbofnodesconnected == 1) {
                        if (this.controller.grf.oneconnectionatleast && !this.controller.grf.onedisconnectionatleast) {
                            this.controller.modify("connect node #" + this.controller.grf.inodeconnected + " to node #" + mouseN, false, true);
                        } else if (!this.controller.grf.oneconnectionatleast && this.controller.grf.onedisconnectionatleast) {
                            this.controller.modify("disconnect node #" + this.controller.grf.inodeconnected + " from node #" + mouseN, false, false);
                        }
                    } else if (this.controller.grf.nbofnodesconnected > 1) {
                        if (this.controller.grf.oneconnectionatleast && !this.controller.grf.onedisconnectionatleast) {
                            this.controller.modify("connect " + this.controller.grf.nbofnodesconnected + " nodes to node #" + mouseN, false, true);
                        } else if (!this.controller.grf.oneconnectionatleast && this.controller.grf.onedisconnectionatleast) {
                            this.controller.modify("disconnect " + this.controller.grf.nbofnodesconnected + " nodes from node #" + mouseN, false, false);
                        } else if (this.controller.grf.oneconnectionatleast && this.controller.grf.onedisconnectionatleast) {
                            this.controller.modify("(dis)connect " + this.controller.grf.nbofnodesconnected + " nodes (from)to node #" + mouseN, false, true);
                        }
                    }
                }
            }
            this.editor.pGraph.invalidate();
            this.editor.pGraph.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        this.controller.mouseOX = e.getX();
        this.controller.mouseOY = e.getY();
        this.controller.mouseM = false;
        this.controller.mouseD = true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.controller.grf == null) {
            return;
        }
        if (SwingUtilities.isRightMouseButton(e)) {
            if (e.isPopupTrigger() || !SystemUtils.IS_OS_WINDOWS) {
                this.editor.popText.show(e.getComponent(), e.getX(), e.getY());
                return;
            }
            return;
        }
        this.controller.mouseD = false;
        if (!this.controller.mouseM || e.isControlDown() || e.isAltDown()) {
            this.controller.SelectionRectangle.height = 0;
            this.controller.SelectionRectangle.width = 0;
            return;
        }
        if (this.controller.SelectionRectangle.width != 0 && this.controller.SelectionRectangle.height != 0) {
            this.controller.mouseOX = -1;
            this.controller.mouseOY = -1;
            this.controller.getMouseNodes();
            this.controller.SelectionRectangle.height = 0;
            this.controller.SelectionRectangle.width = 0;
            this.controller.mouseM = false;
            this.controller.grf.inodemoved = -1;
            this.controller.grf.nbofnodesmoved = 0;
            this.editor.pGraph.invalidate();
            this.editor.pGraph.repaint();
            return;
        }
        this.controller.mouseOX = -1;
        this.controller.mouseOY = -1;
        if (this.controller.grammar.dispGrid && this.controller.grf != null) {
            for (int inode = 0; inode < this.controller.grf.posX.size(); ++inode) {
                this.controller.grf.posX.set(inode, this.controller.grf.posX.get(inode) / 20 * 20);
                this.controller.grf.posY.set(inode, this.controller.grf.posY.get(inode) / 20 * 20);
            }
        }
        if (this.controller.grf.nbofnodesmoved > 1) {
            this.controller.modify("move " + this.controller.grf.nbofnodesmoved + " nodes", false, false);
        } else if (this.controller.grf.inodemoved != -1) {
            this.controller.modify("move node #" + this.controller.grf.inodemoved, false, false);
        }
        this.controller.SelectionRectangle.height = 0;
        this.controller.SelectionRectangle.width = 0;
        this.controller.mouseM = false;
        this.controller.grf.inodemoved = -1;
        this.controller.grf.nbofnodesmoved = 0;
        this.editor.pGraph.invalidate();
        this.editor.pGraph.repaint();
    }
}

